class LaserTracer extends Projectile;

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	Velocity = Speed * vector(Rotation);
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
	Destroy();
}

simulated function ProcessTouch (Actor Other, vector HitLocation)
{
local EnergyBurst EB;

	if ( Other.IsA('Balloon') || Other == Level )
		{
		EB = Spawn(class'EnergyBurst',,, HitLocation);
		EB.DrawScale = 0.5;
		}
}

defaultproperties
{
     speed=2500.000000
     MaxSpeed=2500.000000
     bReplicateInstigator=False
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=0.600000
     Style=STY_Translucent
     Texture=FireTexture'UnrealShare.Effect1.FireEffect1u'
     Mesh=LodMesh'Botpack.MiniTrace'
     DrawScale=0.400000
     AmbientGlow=187
     bUnlit=True
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=255
     LightHue=30
     LightSaturation=69
     LightRadius=5
}
